<?php

namespace Tests\Feature;

use App\Models\Empresa;
use App\Models\EmpresaProtocolo;
use App\Models\EmpresaProtocoloPeriodo;
use App\Models\Protocolo;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;

class ProtocoloPeriodoExpiredMessageTest extends TestCase
{
    use RefreshDatabase;

    public function test_expired_link_displays_message(): void
    {
        $empresa = Empresa::create([
            'name' => 'Empresa',
            'email' => 'empresa@example.com',
            'password' => bcrypt('secret'),
        ]);

        $protocolo = Protocolo::create([
            'nome' => 'Teste',
            'tipo' => 'simples',
            'status' => true,
            'permitir_pf' => true,
        ]);

        $ep = EmpresaProtocolo::create([
            'empresa_id' => $empresa->id,
            'protocolo_id' => $protocolo->id,
            'ativo' => true,
        ]);

        EmpresaProtocoloPeriodo::create([
            'empresa_protocolo_id' => $ep->id,
            'inicio' => now()->subDays(5)->toDateString(),
            'fim' => now()->subDay()->toDateString(),
            'token' => 'abc',
        ]);

        $response = $this->get(route('protocolo.responder', 'abc'));

        $response->assertStatus(200);
        $response->assertSee('A resposta a esse protocolo foi encerrada pela empresa.');
    }
}
