<?php

namespace Tests\Feature;

use App\Models\Empresa;
use App\Models\EmpresaProtocolo;
use App\Models\EmpresaProtocoloPeriodo;
use App\Models\Pergunta;
use App\Models\Protocolo;
use App\Models\ProtocoloResultado;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;

class ParImparScoreTest extends TestCase
{
    use RefreshDatabase;

    public function test_par_impar_scores_are_calculated_and_displayed()
    {
        $empresa = Empresa::create([
            'name' => 'Empresa',
            'email' => 'empresa@example.com',
            'password' => bcrypt('secret'),
        ]);

        $protocolo = Protocolo::create([
            'nome' => 'Teste',
            'tipo' => 'par_impar',
            'status' => true,
            'permitir_pf' => true,
        ]);

        $p1 = Pergunta::create([
            'protocolo_id' => $protocolo->id,
            'ordem' => 2,
            'texto' => 'Q1',
        ]);
        $p2 = Pergunta::create([
            'protocolo_id' => $protocolo->id,
            'ordem' => 5,
            'texto' => 'Q2',
        ]);

        ProtocoloResultado::create([
            'protocolo_id' => $protocolo->id,
            'pontuacao_de' => 0,
            'pontuacao_ate' => 3,
            'rotulo' => 'Par baixo',
            'texto' => 'Resultado par baixo',
            'paridade' => 'par',
        ]);
        ProtocoloResultado::create([
            'protocolo_id' => $protocolo->id,
            'pontuacao_de' => 4,
            'pontuacao_ate' => 10,
            'rotulo' => 'Par alto',
            'texto' => 'Resultado par alto',
            'paridade' => 'par',
        ]);
        ProtocoloResultado::create([
            'protocolo_id' => $protocolo->id,
            'pontuacao_de' => 0,
            'pontuacao_ate' => 7,
            'rotulo' => 'Ímpar baixo',
            'texto' => 'Resultado ímpar baixo',
            'paridade' => 'impar',
        ]);
        ProtocoloResultado::create([
            'protocolo_id' => $protocolo->id,
            'pontuacao_de' => 8,
            'pontuacao_ate' => 10,
            'rotulo' => 'Ímpar alto',
            'texto' => 'Resultado ímpar alto',
            'paridade' => 'impar',
        ]);

        $ep = EmpresaProtocolo::create([
            'empresa_id' => $empresa->id,
            'protocolo_id' => $protocolo->id,
            'ativo' => true,
        ]);

        EmpresaProtocoloPeriodo::create([
            'empresa_protocolo_id' => $ep->id,
            'inicio' => now()->subDay()->toDateString(),
            'fim' => now()->addDay()->toDateString(),
            'token' => 'abc',
        ]);

        $response = $this->post(route('protocolo.responder.salvar', 'abc'), [
            'cpf' => '12345678901',
            'answers' => json_encode([
                $p1->id => 5,
                $p2->id => 9,
            ]),
        ]);

        $response->assertStatus(200);

        $response->assertSeeText('Resultado: 5 Pontos - Par alto');
        $response->assertSeeText('Resultado par alto');
        $response->assertSeeText('Resultado: 9 Pontos - Ímpar alto');
        $response->assertSeeText('Resultado ímpar alto');


        $this->assertDatabaseHas('protocolo_respostas', [
            'pontuacao_par' => 5,
            'pontuacao_impar' => 9,
        ]);
    }
}
