<?php $__env->startSection('title', 'Visualização de Resultados'); ?>

<?php $__env->startSection('content'); ?>
  <form method="GET" action="<?php echo e(url()->current()); ?>" class="mb-6 flex gap-2">
    <select name="protocolo_id" onchange="this.form.submit()" class="border-gray-300 rounded-lg">
      <option value="" <?php if(!$protocoloId): echo 'selected'; endif; ?>>Todos</option>
      <?php $__currentLoopData = $protocolos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $prot): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <option value="<?php echo e($prot->id); ?>" <?php if($prot->id == $protocoloId): echo 'selected'; endif; ?>><?php echo e($prot->nome); ?></option>
      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </select>
    <?php if($periodos->isNotEmpty()): ?>
      <select name="periodo_id" onchange="this.form.submit()" class="border-gray-300 rounded-lg">
        <option value="" <?php if(!$periodoId): echo 'selected'; endif; ?>>Todos</option>
        <?php $__currentLoopData = $periodos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $per): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <option value="<?php echo e($per->id); ?>" <?php if($per->id == $periodoId): echo 'selected'; endif; ?>>
            <?php echo e($per->inicio->format('d/m/Y')); ?> - <?php echo e($per->fim->format('d/m/Y')); ?>

          </option>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      </select>
    <?php endif; ?>
  </form>

  <section class="grid grid-cols-1 md:grid-cols-2 xl:grid-cols-4 gap-4 sm:gap-6">
    <div class="bg-white rounded-xl border border-gray-200 p-5 shadow-soft">
      <div class="flex items-center gap-4">
        <span class="p-3 rounded-xl bg-green-50 text-green-600"><i class="fa-solid fa-face-smile text-lg"></i></span>
        <div>
          <p class="text-sm text-gray-600">Pontuação Média</p>
          <p class="text-2xl font-semibold"><?php echo e($mediaPontuacao); ?></p>
        </div>
      </div>
    </div>
    <div class="bg-white rounded-xl border border-gray-200 p-5 shadow-soft">
      <div class="flex items-center gap-4">
        <span class="p-3 rounded-xl bg-yellow-50 text-yellow-600"><i class="fa-solid fa-list-check text-lg"></i></span>
        <div>
          <p class="text-sm text-gray-600">Total de Respostas</p>
          <p class="text-2xl font-semibold"><?php echo e($totalRespostas); ?></p>
        </div>
      </div>
    </div>
    <div class="bg-white rounded-xl border border-gray-200 p-5 shadow-soft">
      <div class="flex items-center gap-4">
        <span class="p-3 rounded-xl bg-primary-50 text-primary-600"><i class="fa-solid fa-arrow-up text-lg"></i></span>
        <div>
          <p class="text-sm text-gray-600">Pontuação Máxima</p>
          <p class="text-2xl font-semibold"><?php echo e($maxPontuacao); ?></p>
        </div>
      </div>
    </div>
    <div class="bg-white rounded-xl border border-gray-200 p-5 shadow-soft">
      <div class="flex items-center gap-4">
        <span class="p-3 rounded-xl bg-purple-50 text-purple-600"><i class="fa-solid fa-arrow-down text-lg"></i></span>
        <div>
          <p class="text-sm text-gray-600">Pontuação Mínima</p>
          <p class="text-2xl font-semibold"><?php echo e($minPontuacao); ?></p>
        </div>
      </div>
    </div>
  </section>

  <section class="grid grid-cols-1 xl:grid-cols-2 gap-6 mt-6">
    <div class="bg-white rounded-xl border border-gray-200 p-5 shadow-soft">
      <div class="flex items-center justify-between mb-4">
        <h3 class="text-base font-semibold">Pontuação ao Longo do Tempo</h3>
      </div>
      <div class="h-72"><canvas id="bemestarChart"></canvas></div>
    </div>
    <div class="bg-white rounded-xl border border-gray-200 p-5 shadow-soft">
      <div class="flex items-center justify-between mb-4">
        <h3 class="text-base font-semibold">Distribuição por Categoria</h3>
      </div>
      <div class="h-72"><canvas id="categoriaChart"></canvas></div>
      <?php if(!empty($categoriaLabels)): ?>
        <div class="mt-4 flex flex-wrap gap-4">
          <?php $__currentLoopData = $categoriaLabels; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <span class="text-sm text-gray-600"><?php echo e($label); ?>: <?php echo e($categoriaPercent[$i]); ?>% (<?php echo e($categoriaData[$i]); ?>)</span>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
      <?php endif; ?>
    </div>
  </section>

  <section class="grid grid-cols-1 xl:grid-cols-3 gap-6 mt-6">
    <div class="bg-white rounded-xl border border-gray-200 p-5 shadow-soft">
      <h3 class="text-base font-semibold mb-4">Respostas por Mês</h3>
      <div class="h-60"><canvas id="estresseChart"></canvas></div>
    </div>
    <div class="bg-white rounded-xl border border-gray-200 p-5 shadow-soft xl:col-span-2">
      <h3 class="text-base font-semibold mb-4">Participação por Departamento</h3>
      <div class="space-y-4">
        <?php $__empty_1 = true; $__currentLoopData = $departamentos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dep): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
          <div class="flex items-center justify-between">
            <span class="text-sm text-gray-600"><?php echo e($dep['nome']); ?></span>
            <div class="flex items-center">
              <div class="w-40 h-2 bg-gray-200 rounded-full">
                <div class="h-2 bg-primary-600 rounded-full" style="width:<?php echo e($dep['percent']); ?>%"></div>
              </div>
              <span class="ml-3 text-sm text-gray-600"><?php echo e($dep['percent']); ?>%</span>
            </div>
          </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
          <p class="text-sm text-gray-500">Sem respostas registradas</p>
        <?php endif; ?>
      </div>
    </div>
  </section>

  <section class="bg-white rounded-xl border border-gray-200 p-5 shadow-soft mt-6">
    <h3 class="text-base font-semibold mb-4">Média por Departamento</h3>
    <div class="h-72"><canvas id="departamentoChart"></canvas></div>
  </section>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.1"></script>
<script>
  const bemestarCtx = document.getElementById('bemestarChart');
  new Chart(bemestarCtx, {
    type: 'line',
    data: {
      labels: <?php echo json_encode($lineLabels, 15, 512) ?>,
      datasets: [{
        label: 'Pontuação média',
        data: <?php echo json_encode($lineData, 15, 512) ?>,
        borderColor: '#3b82f6',
        backgroundColor: 'rgba(59,130,246,0.1)',
        tension: 0.4
      }]
    }
  });

  const categoriaCtx = document.getElementById('categoriaChart');
  new Chart(categoriaCtx, {
    type: 'doughnut',
    data: {
      labels: <?php echo json_encode($categoriaLabels, 15, 512) ?>,
      datasets: [{
        data: <?php echo json_encode($categoriaPercent, 15, 512) ?>,
        backgroundColor: ['#10b981','#3b82f6','#ef4444','#8b5cf6','#f59e0b']
      }]
    }
  });

  const estresseCtx = document.getElementById('estresseChart');
  new Chart(estresseCtx, {
    type: 'bar',
    data: {
      labels: <?php echo json_encode($barLabels, 15, 512) ?>,
      datasets: [{
        label: 'Respostas',
        data: <?php echo json_encode($barData, 15, 512) ?>,
        backgroundColor: '#f59e0b'
      }]
    }
  });

  const departamentoCtx = document.getElementById('departamentoChart');
  new Chart(departamentoCtx, {
    type: 'line',
    data: {
      labels: <?php echo json_encode($departamentoLabels, 15, 512) ?>,
      datasets: <?php echo json_encode($departamentoSeries, 15, 512) ?>
    }
  });
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.empresas', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/mac/Documents/projetos/AzoProtocolo/resources/views/dashboard-resultados.blade.php ENDPATH**/ ?>