<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title><?php echo $__env->yieldContent('title', 'Dashboard - Gestão de Empresas e Protocolos'); ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
      tailwind.config = {
        theme: {
          extend: {
            colors: {
              primary: { 50: '#f0f9ff', 500: '#3b82f6', 600: '#2563eb', 700: '#1d4ed8' }
            },
            boxShadow: {
              soft: '0 10px 20px -10px rgba(2,6,23,0.15)'
            }
          }
        }
      }
    </script>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css" rel="stylesheet" />
</head>
<body class="bg-gray-50 text-gray-900">
    <!-- Mobile sidebar backdrop -->
    <div id="backdrop" class="fixed inset-0 bg-gray-900/40 backdrop-blur-sm z-40 hidden lg:hidden"></div>

    <!-- Sidebar -->
    <?php echo $__env->make('layouts.sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <!-- Main wrapper with left padding on lg -->
    <div class="min-h-screen lg:pl-72 flex flex-col">
      <!-- Top navbar -->
      <header class="sticky top-0 z-40 bg-white/85 backdrop-blur border-b border-gray-200">
        <div class="h-16 px-4 sm:px-6 flex items-center justify-between">
          <div class="flex items-center gap-3">
            <button id="sidebarToggle" class="lg:hidden inline-flex h-10 w-10 items-center justify-center rounded-lg border border-gray-200 text-gray-600">
              <i class="fa-solid fa-bars"></i>
            </button>
            <h1 class="text-lg sm:text-xl font-semibold tracking-tight"><?php echo $__env->yieldContent('title', 'Dashboard de Gestão'); ?></h1>
          </div>
          <div class="flex items-center gap-3 sm:gap-4">
            <div class="hidden md:block">
              <label class="relative block">
                <span class="sr-only">Pesquisar</span>
                <span class="absolute inset-y-0 left-0 flex items-center pl-3"><i class="fa-solid fa-magnifying-glass text-gray-400"></i></span>
                <input class="pl-9 pr-3 py-2 w-64 rounded-lg border border-gray-200 focus:outline-none focus:ring-2 focus:ring-primary-500 focus:border-transparent text-sm" placeholder="Pesquisar..." />
              </label>
            </div>
            <button class="relative p-2 rounded-lg border border-gray-200">
              <i class="fa-solid fa-bell"></i>
              <span class="absolute -top-0.5 -right-0.5 block h-2.5 w-2.5 rounded-full bg-red-500"></span>
            </button>
            <div class="relative">
              <button id="userMenuBtn" class="flex items-center gap-2 rounded-lg border border-gray-200 px-2.5 py-1.5">
                <img class="h-7 w-7 rounded-full" src="https://i.pravatar.cc/100?img=8" alt="avatar" />
                <span class="hidden sm:block text-sm font-medium"><?php echo e(auth()->user()->name); ?></span>
                <i class="fa-solid fa-chevron-down text-xs text-gray-500"></i>
              </button>
              <div id="userMenu" class="hidden absolute right-0 mt-2 w-44 bg-white border border-gray-200 rounded-lg shadow-soft overflow-hidden">
                <a href="#" class="block px-3 py-2 text-sm hover:bg-gray-50">Perfil</a>
                <a href="#" class="block px-3 py-2 text-sm hover:bg-gray-50">Preferências</a>
                <div class="border-t"></div>
                <form method="POST" action="<?php echo e(route('logout')); ?>">
                  <?php echo csrf_field(); ?>
                  <button type="submit" class="w-full text-left block px-3 py-2 text-sm text-red-600 hover:bg-red-50">Sair</button>
                </form>
              </div>
            </div>
          </div>
        </div>
      </header>

      <main class="flex-1 p-6">
        <?php echo $__env->yieldContent('content'); ?>
      </main>
    </div>

    <script>
      const qs  = (s, el=document) => el.querySelector(s);
      const sidebar = qs('#sidebar');
      const backdrop = qs('#backdrop');
      qs('#sidebarToggle')?.addEventListener('click', () => {
        const open = sidebar.classList.toggle('-translate-x-full');
        const isVisible = !sidebar.classList.contains('-translate-x-full');
        backdrop.classList.toggle('hidden', !isVisible);
      });
      backdrop.addEventListener('click', () => {
        sidebar.classList.add('-translate-x-full');
        backdrop.classList.add('hidden');
      });

      const userBtn = qs('#userMenuBtn');
      const userMenu = qs('#userMenu');
      userBtn?.addEventListener('click', (e) => {
        e.stopPropagation();
        userMenu.classList.toggle('hidden');
      });
      document.addEventListener('click', (e) => {
        if (!userMenu.contains(e.target)) userMenu.classList.add('hidden');
      });
    </script>
</body>
</html>
<?php /**PATH /Users/mac/Documents/projetos/AzoProtocolo/resources/views/layouts/gestao.blade.php ENDPATH**/ ?>