<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Resultado - <?php echo e($protocolo->nome); ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
      tailwind.config = {
        theme: {
          extend: {
            colors: {
              primary: { 50: '#eff6ff', 100: '#dbeafe', 200: '#bfdbfe', 500: '#3b82f6', 600: '#2563eb', 700: '#1d4ed8' }
            },
            boxShadow: {
              soft: '0 10px 25px -10px rgba(2,6,23,0.15)'
            }
          }
        }
      }
    </script>
</head>
<body class="min-h-screen bg-gradient-to-br from-primary-50 via-white to-cyan-50 text-gray-900">
  <div class="max-w-3xl md:max-w-4xl mx-auto px-4 sm:px-6 py-8 sm:py-12">
    <!-- Header Card -->
    <header class="bg-white/80 backdrop-blur border border-gray-200 rounded-2xl shadow-soft p-5 sm:p-7 flex items-start gap-4">
      <div class="shrink-0 h-12 w-12 rounded-xl bg-primary-600 text-white flex items-center justify-center">
        <!-- trophy icon -->
        <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" viewBox="0 0 24 24" fill="currentColor"><path d="M4 4a1 1 0 011-1h14a1 1 0 011 1v2a4 4 0 01-4 4h-1.1A5.002 5.002 0 0113 13v1h3a1 1 0 110 2h-8a1 1 0 110-2h3v-1a5.002 5.002 0 01-2.9-3H7A4 4 0 013 6V4zm2 2a2 2 0 002 2h2V5H6v1zm10 1a2 2 0 002-2V5h-4v3h2z"/></svg>
      </div>
      <div class="flex-1">
        <h1 class="text-xl sm:text-2xl font-semibold tracking-tight"><?php echo e($protocolo->nome); ?></h1>
        <p class="text-sm text-gray-600">Aqui está um resumo claro do seu resultado. Você pode imprimir, copiar o link ou voltar quando quiser.</p>
        <div class="mt-3 flex flex-wrap gap-2">
          <button onclick="window.print()" class="inline-flex items-center gap-2 px-3 py-1.5 text-sm rounded-lg border border-gray-200 hover:bg-gray-50">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" viewBox="0 0 20 20" fill="currentColor"><path d="M6 2a2 2 0 00-2 2v2h12V4a2 2 0 00-2-2H6z"/><path d="M4 9a2 2 0 00-2 2v3a1 1 0 001 1h2v-2h10v2h2a1 1 0 001-1v-3a2 2 0 00-2-2H4z"/><path d="M6 14h8v4H6z"/></svg>
            Imprimir
          </button>
        
          <a href="<?php echo e(route('protocolos.index')); ?>" class="inline-flex items-center gap-2 px-3 py-1.5 text-sm rounded-lg border border-gray-200 hover:bg-gray-50">Voltar</a>
        </div>
      </div>
    </header>

    <!-- Result Blocks -->
    <?php if($protocolo->tipo === 'par_impar'): ?>
      <section class="mt-6 grid grid-cols-1 md:grid-cols-2 gap-4 sm:gap-6">
        <!-- PAR -->
        <article class="bg-white rounded-2xl border border-gray-200 shadow-soft p-5">
          <div class="flex items-center justify-between">
            <h2 class="text-base font-semibold">Pontuação</h2>
            <?php if($resultadoPar): ?>
              <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-blue-50 text-blue-700 border border-blue-100"><?php echo e($resultadoPar->rotulo); ?></span>
            <?php endif; ?>
          </div>
          <div class="mt-4 flex items-end gap-4">
            <div class="relative isolate">
              <div class="h-20 w-20 rounded-2xl bg-gradient-to-br from-primary-100 to-white border border-gray-200 flex items-center justify-center">
                <span class="text-2xl font-bold text-gray-900"><?php echo e($totalPar); ?></span>
              </div>
            </div>
            <div class="text-sm text-gray-600 flex-1">
              <?php if($resultadoPar): ?>
                <p>Resultado: <?php echo e($totalPar); ?> Pontos - <?php echo e($resultadoPar->rotulo); ?></p>
                <p><?php echo e($resultadoPar->texto); ?></p>
              <?php else: ?>
                <p>Obrigado por responder. Veja o detalhamento abaixo.</p>
              <?php endif; ?>
            </div>
          </div>
        </article>
        <!-- ÍMPAR -->
        <article class="bg-white rounded-2xl border border-gray-200 shadow-soft p-5">
          <div class="flex items-center justify-between">
            <h2 class="text-base font-semibold">Pontuação </h2>
            <?php if($resultadoImpar): ?>
              <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-emerald-50 text-emerald-700 border border-emerald-100"><?php echo e($resultadoImpar->rotulo); ?></span>
            <?php endif; ?>
          </div>
          <div class="mt-4 flex items-end gap-4">
            <div class="h-20 w-20 rounded-2xl bg-gradient-to-br from-emerald-100 to-white border border-gray-200 flex items-center justify-center">
              <span class="text-2xl font-bold text-gray-900"><?php echo e($totalImpar); ?></span>
            </div>
            <div class="text-sm text-gray-600 flex-1">
              <?php if($resultadoImpar): ?>
                <p>Resultado: <?php echo e($totalImpar); ?> Pontos - <?php echo e($resultadoImpar->rotulo); ?></p>
                <p><?php echo e($resultadoImpar->texto); ?></p>
              <?php else: ?>
                <p>Obrigado por responder. Veja o detalhamento abaixo.</p>
              <?php endif; ?>
            </div>
          </div>
        </article>
      </section>
    <?php else: ?>
      <section class="mt-6">
        <article class="bg-white rounded-2xl border border-gray-200 shadow-soft p-6 sm:p-8">
          <div class="flex items-center justify-between">
            <h2 class="text-base font-semibold">Seu Resultado</h2>
            <?php if($resultado): ?>
              <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-blue-50 text-blue-700 border border-blue-100"><?php echo e($resultado->rotulo); ?></span>
            <?php endif; ?>
          </div>
          <div class="mt-5 flex items-end gap-5">
            <div class="h-24 w-24 rounded-3xl bg-gradient-to-br from-primary-100 to-white border border-gray-200 flex items-center justify-center shadow-inner">
              <span class="text-3xl font-extrabold text-gray-900"><?php echo e($total); ?></span>
            </div>
            <div class="text-sm text-gray-700 leading-relaxed flex-1">
              <?php if($resultado): ?>
                <p><?php echo e($resultado->texto); ?></p>
              <?php else: ?>
                <p>Obrigado por responder ao protocolo.</p>
              <?php endif; ?>
            </div>
          </div>
        </article>
      </section>
    <?php endif; ?>

    <!-- Extras: próximos passos e observações -->
    <section class="mt-6 grid grid-cols-1 md:grid-cols-2 gap-4 sm:gap-6">
      <div class="bg-white rounded-2xl border border-gray-200 shadow-soft p-5">
        <h3 class="text-sm font-semibold text-gray-900">Próximos passos</h3>
        <ul class="mt-3 space-y-2 text-sm text-gray-700">
          <li class="flex gap-2"><span class="mt-1 h-2 w-2 rounded-full bg-primary-500"></span> Revise o resultado com calma e, se desejar, converse com um profissional de confiança.</li>
          <li class="flex gap-2"><span class="mt-1 h-2 w-2 rounded-full bg-primary-500"></span> Salve ou imprima este resumo para acompanhar sua evolução.</li>
          <li class="flex gap-2"><span class="mt-1 h-2 w-2 rounded-full bg-primary-500"></span> Caso haja orientações específicas no texto do resultado, siga-as no seu tempo.</li>
        </ul>
      </div>
      <div class="bg-white rounded-2xl border border-gray-200 shadow-soft p-5">
        <h3 class="text-sm font-semibold text-gray-900">Observações</h3>
        <p class="mt-3 text-sm text-gray-700">Este material tem caráter informativo. Para decisões de saúde, procure orientação profissional qualificada.</p>
        <div class="mt-4 flex flex-wrap gap-2">
          <button onclick="window.print()" class="inline-flex items-center gap-2 px-3 py-1.5 text-sm rounded-lg bg-primary-600 text-white hover:bg-primary-700">Imprimir</button>
         
        </div>
      </div>
    </section>
  </div>

  <script>
    function copyLink(btn){
      navigator.clipboard.writeText(window.location.href).then(() => {
        btn.textContent = 'Link copiado!';
        setTimeout(()=>{ btn.textContent = 'Copiar link'; }, 2000);
      }).catch(() => alert('Não foi possível copiar o link.'));
    }
    document.getElementById('copyLink')?.addEventListener('click', e => copyLink(e.currentTarget));
    document.getElementById('copyLink2')?.addEventListener('click', e => copyLink(e.currentTarget));
  </script>
</body>
</html><?php /**PATH /Users/mac/Documents/projetos/AzoProtocolo/resources/views/protocolos/resposta-resultado.blade.php ENDPATH**/ ?>