<!DOCTYPE html>
<html lang="pt-BR">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>Dashboard - Gestão de Empresas e Protocolos</title>
  <script src="https://cdn.tailwindcss.com"></script>
  <script>
    tailwind.config = {
      theme: {
        extend: {
          colors: {
            primary: { 50: '#f0f9ff', 500: '#3b82f6', 600: '#2563eb', 700: '#1d4ed8' }
          },
          boxShadow: {
            soft: '0 10px 20px -10px rgba(2,6,23,0.15)'
          }
        }
      }
    }
  </script>
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css" rel="stylesheet" />
</head>
<body class="bg-gray-50 text-gray-900">
  <!-- Mobile sidebar backdrop -->
  <div id="backdrop" class="fixed inset-0 bg-gray-900/40 backdrop-blur-sm z-40 hidden lg:hidden"></div>

    <!-- Sidebar -->
    <?php echo $__env->make('layouts.sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

  <!-- Main wrapper with left padding on lg -->
  <div class="min-h-screen lg:pl-72 flex flex-col">
    <!-- Top navbar -->
    <header class="sticky top-0 z-40 bg-white/85 backdrop-blur border-b border-gray-200">
      <div class="h-16 px-4 sm:px-6 flex items-center justify-between">
        <div class="flex items-center gap-3">
          <button id="sidebarToggle" class="lg:hidden inline-flex h-10 w-10 items-center justify-center rounded-lg border border-gray-200 text-gray-600">
            <i class="fa-solid fa-bars"></i>
          </button>
          <h1 class="text-lg sm:text-xl font-semibold tracking-tight">Dashboard de Gestão</h1>
        </div>
        <div class="flex items-center gap-3 sm:gap-4">
          <div class="hidden md:block">
            <label class="relative block">
              <span class="sr-only">Pesquisar</span>
              <span class="absolute inset-y-0 left-0 flex items-center pl-3"><i class="fa-solid fa-magnifying-glass text-gray-400"></i></span>
              <input class="pl-9 pr-3 py-2 w-64 rounded-lg border border-gray-200 focus:outline-none focus:ring-2 focus:ring-primary-500 focus:border-transparent text-sm" placeholder="Pesquisar..." />
            </label>
          </div>
          <button class="relative p-2 rounded-lg border border-gray-200">
            <i class="fa-solid fa-bell"></i>
            <span class="absolute -top-0.5 -right-0.5 block h-2.5 w-2.5 rounded-full bg-red-500"></span>
          </button>
          <div class="relative">
            <button id="userMenuBtn" class="flex items-center gap-2 rounded-lg border border-gray-200 px-2.5 py-1.5">
              <img class="h-7 w-7 rounded-full" src="https://i.pravatar.cc/100?img=8" alt="avatar" />
              <span class="hidden sm:block text-sm font-medium"><?php echo e(auth()->user()->name); ?></span>
              <i class="fa-solid fa-chevron-down text-xs text-gray-500"></i>
            </button>
            <div id="userMenu" class="hidden absolute right-0 mt-2 w-44 bg-white border border-gray-200 rounded-lg shadow-soft overflow-hidden">
              <a href="#" class="block px-3 py-2 text-sm hover:bg-gray-50">Perfil</a>
              <a href="#" class="block px-3 py-2 text-sm hover:bg-gray-50">Preferências</a>
              <div class="border-t"></div>
              <form method="POST" action="<?php echo e(route('logout')); ?>">
                <?php echo csrf_field(); ?>
                <button type="submit" class="w-full text-left block px-3 py-2 text-sm text-red-600 hover:bg-red-50">Sair</button>
              </form>
            </div>
          </div>
        </div>
      </div>
    </header>

    <!-- Page content -->
    <main class="flex-1 p-4 sm:p-6 space-y-6">
      <!-- OVERVIEW -->
      <section id="overview" class="space-y-6">
        <!-- Stats -->
        <div class="grid grid-cols-1 sm:grid-cols-2 xl:grid-cols-4 gap-4 sm:gap-6">
          <div class="bg-white rounded-xl border border-gray-200 p-5 shadow-soft">
            <div class="flex items-center gap-4">
              <span class="p-3 rounded-xl bg-primary-50 text-primary-600"><i class="fa-solid fa-building text-lg"></i></span>
              <div>
                <p class="text-sm text-gray-600">Total de Empresas</p>
                <p class="text-2xl font-semibold"><?php echo e($stats['totalEmpresas']); ?></p>
              </div>
            </div>
          </div>
          <div class="bg-white rounded-xl border border-gray-200 p-5 shadow-soft">
            <div class="flex items-center gap-4">
              <span class="p-3 rounded-xl bg-green-50 text-green-600"><i class="fa-solid fa-clipboard-list text-lg"></i></span>
              <div>
                <p class="text-sm text-gray-600">Protocolos Ativos</p>
                <p class="text-2xl font-semibold"><?php echo e($stats['protocolosAtivos']); ?></p>
              </div>
            </div>
          </div>
          <div class="bg-white rounded-xl border border-gray-200 p-5 shadow-soft">
            <div class="flex items-center gap-4">
              <span class="p-3 rounded-xl bg-yellow-50 text-yellow-600"><i class="fa-solid fa-chart-line text-lg"></i></span>
              <div>
                <p class="text-sm text-gray-600">Respostas Este Mês</p>
                <p class="text-2xl font-semibold"><?php echo e(number_format($stats['respostasMes'], 0, ',', '.')); ?></p>
              </div>
            </div>
          </div>
          <div class="bg-white rounded-xl border border-gray-200 p-5 shadow-soft">
            <div class="flex items-center gap-4">
              <span class="p-3 rounded-xl bg-purple-50 text-purple-600"><i class="fa-solid fa-users text-lg"></i></span>
              <div>
                <p class="text-sm text-gray-600">Usuários Ativos</p>
                <p class="text-2xl font-semibold"><?php echo e($stats['usuariosAtivos']); ?></p>
              </div>
            </div>
          </div>
        </div>

        <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
          <div class="bg-white rounded-xl border border-gray-200 p-5 shadow-soft">
            <h3 class="text-base font-semibold mb-4">Ações Rápidas</h3>
            <div class="space-y-3">
              <a href="<?php echo e(route('empresas.create')); ?>" class="w-full flex items-center justify-between p-3 rounded-lg bg-primary-50 hover:bg-primary-100 transition">
                <span class="flex items-center gap-3 text-primary-700 font-medium"><i class="fa-solid fa-plus"></i>Nova Empresa</span>
                <i class="fa-solid fa-arrow-right text-primary-700"></i>
              </a>
              <a href="<?php echo e(route('protocolos.create')); ?>" class="w-full flex items-center justify-between p-3 rounded-lg bg-green-50 hover:bg-green-100 transition">
                <span class="flex items-center gap-3 text-green-700 font-medium"><i class="fa-solid fa-plus"></i>Novo Protocolo</span>
                <i class="fa-solid fa-arrow-right text-green-700"></i>
              </a>
              <a href="<?php echo e(route('dashboard.resultados')); ?>" class="w-full flex items-center justify-between p-3 rounded-lg bg-purple-50 hover:bg-purple-100 transition">
                <span class="flex items-center gap-3 text-purple-700 font-medium"><i class="fa-solid fa-download"></i>Exportar Relatório</span>
                <i class="fa-solid fa-arrow-right text-purple-700"></i>
              </a>
            </div>
          </div>
          <div class="bg-white rounded-xl border border-gray-200 p-5 shadow-soft">
            <h3 class="text-base font-semibold mb-4">Atividade Recente</h3>
            <div class="space-y-4">
              <?php $__empty_1 = true; $__currentLoopData = $recent; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
              <div class="flex items-start gap-3">
                <span class="mt-1 h-2.5 w-2.5 rounded-full <?php echo e($item['color']); ?>"></span>
                <div class="text-sm">
                  <p><?php echo e($item['descricao']); ?></p>
                  <p class="text-gray-500 text-xs"><?php echo e($item['data']->diffForHumans()); ?></p>
                </div>
              </div>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
              <p class="text-sm text-gray-500">Nenhuma atividade recente.</p>
              <?php endif; ?>
            </div>
          </div>
        </div>

        <div class="bg-white rounded-xl border border-gray-200 p-5 shadow-soft">
          <h3 class="text-base font-semibold mb-4">Ranking de Respostas por Empresa</h3>
          <ol class="space-y-2">
            <?php $__empty_1 = true; $__currentLoopData = $ranking; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <li class="flex justify-between text-sm">
              <span><?php echo e($item->empresa->name); ?></span>
              <span class="font-medium"><?php echo e($item->total); ?></span>
            </li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <p class="text-sm text-gray-500">Nenhuma resposta registrada.</p>
            <?php endif; ?>
          </ol>
        </div>
      </section>

      <!-- EMPRESAS -->
      <section id="empresas" class="hidden space-y-6">
        <div class="flex items-center justify-between">
          <h2 class="text-xl font-semibold">Gestão de Empresas</h2>
          <button onclick="openModal('empresaModal')" class="inline-flex items-center gap-2 bg-primary-600 hover:bg-primary-700 text-white px-4 py-2 rounded-lg">
            <i class="fa-solid fa-plus"></i> Nova Empresa
          </button>
        </div>

        <div class="bg-white rounded-xl border border-gray-200 p-4">
          <div class="flex flex-col md:flex-row gap-3">
            <input class="flex-1 px-3 py-2 rounded-lg border border-gray-300 focus:outline-none focus:ring-2 focus:ring-primary-500" placeholder="Buscar empresas..." />
            <select class="px-3 py-2 rounded-lg border border-gray-300 focus:outline-none focus:ring-2 focus:ring-primary-500">
              <option>Todos os status</option>
              <option>Ativo</option>
              <option>Inativo</option>
            </select>
          </div>
        </div>

        <div class="bg-white rounded-xl border border-gray-200 overflow-hidden">
          <table class="min-w-full divide-y divide-gray-200">
            <thead class="bg-gray-50">
              <tr>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Empresa</th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">CNPJ</th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Funcionários</th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Ações</th>
              </tr>
            </thead>
            <tbody class="bg-white divide-y divide-gray-200">
              <tr class="hover:bg-gray-50">
                <td class="px-6 py-4 whitespace-nowrap">
                  <div class="flex items-center">
                    <div class="w-10 h-10 bg-primary-50 text-primary-600 rounded-full flex items-center justify-center mr-3">
                      <i class="fa-solid fa-building"></i>
                    </div>
                    <div>
                      <div class="text-sm font-medium text-gray-900">TechCorp Ltda</div>
                      <div class="text-sm text-gray-500">contato@techcorp.com</div>
                    </div>
                  </div>
                </td>
                <td class="px-6 py-4 whitespace-nowrap text-sm">12.345.678/0001-90</td>
                <td class="px-6 py-4 whitespace-nowrap text-sm">150</td>
                <td class="px-6 py-4 whitespace-nowrap">
                  <span class="px-2.5 py-0.5 inline-flex text-xs font-semibold rounded-full bg-green-100 text-green-700">Ativo</span>
                </td>
                <td class="px-6 py-4 whitespace-nowrap text-sm">
                  <button class="text-primary-600 hover:text-primary-800 mr-3"><i class="fa-solid fa-pen"></i></button>
                  <button class="text-red-600 hover:text-red-800"><i class="fa-solid fa-trash"></i></button>
                </td>
              </tr>
            </tbody>
          </table>
        </div>
      </section>

      <!-- PROTOCOLOS -->
      <section id="protocolos" class="hidden space-y-6">
        <div class="flex items-center justify-between">
          <h2 class="text-xl font-semibold">Gestão de Protocolos</h2>
          <button onclick="openModal('protocoloModal')" class="inline-flex items-center gap-2 bg-green-600 hover:bg-green-700 text-white px-4 py-2 rounded-lg">
            <i class="fa-solid fa-plus"></i> Novo Protocolo
          </button>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-2 xl:grid-cols-3 gap-6">
          <article class="bg-white rounded-xl border border-gray-200 p-5 shadow-soft hover:shadow-md transition">
            <div class="flex items-center justify-between mb-2">
              <h3 class="font-semibold">Avaliação de Estresse</h3>
              <span class="px-2 py-0.5 text-xs font-semibold rounded-full bg-green-100 text-green-700">Ativo</span>
            </div>
            <p class="text-sm text-gray-600 mb-4">Protocolo para avaliação de níveis de estresse no ambiente de trabalho.</p>
            <div class="flex items-center justify-between text-sm text-gray-500 mb-4">
              <span>15 perguntas</span>
              <span>247 respostas</span>
            </div>
            <div class="flex gap-2">
              <button class="flex-1 bg-primary-50 text-primary-700 py-2 px-3 rounded-lg text-sm hover:bg-primary-100"><i class="fa-solid fa-pen mr-1"></i>Editar</button>
              <button class="flex-1 bg-green-50 text-green-700 py-2 px-3 rounded-lg text-sm hover:bg-green-100"><i class="fa-solid fa-chart-bar mr-1"></i>Relatório</button>
            </div>
          </article>

          <article class="bg-white rounded-xl border border-gray-200 p-5 shadow-soft hover:shadow-md transition">
            <div class="flex items-center justify-between mb-2">
              <h3 class="font-semibold">Bem-estar Mental</h3>
              <span class="px-2 py-0.5 text-xs font-semibold rounded-full bg-green-100 text-green-700">Ativo</span>
            </div>
            <p class="text-sm text-gray-600 mb-4">Avaliação geral do bem-estar mental dos colaboradores.</p>
            <div class="flex items-center justify-between text-sm text-gray-500 mb-4">
              <span>20 perguntas</span>
              <span>189 respostas</span>
            </div>
            <div class="flex gap-2">
              <button class="flex-1 bg-primary-50 text-primary-700 py-2 px-3 rounded-lg text-sm hover:bg-primary-100"><i class="fa-solid fa-pen mr-1"></i>Editar</button>
              <button class="flex-1 bg-green-50 text-green-700 py-2 px-3 rounded-lg text-sm hover:bg-green-100"><i class="fa-solid fa-chart-bar mr-1"></i>Relatório</button>
            </div>
          </article>
        </div>
      </section>
    </main>
  </div>

  <!-- Modal Empresa -->
  <div id="empresaModal" class="fixed inset-0 bg-gray-900/50 hidden items-center justify-center z-50">
    <div class="bg-white rounded-xl shadow-soft p-6 w-full max-w-md mx-4">
      <div class="flex justify-between items-center mb-4">
        <h3 class="text-lg font-semibold">Nova Empresa</h3>
        <button onclick="closeModal('empresaModal')" class="text-gray-500 hover:text-gray-700"><i class="fa-solid fa-xmark"></i></button>
      </div>
      <form class="space-y-4">
        <label class="block text-sm">Nome da Empresa
          <input type="text" class="mt-1 w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-primary-500" />
        </label>
        <label class="block text-sm">CNPJ
          <input type="text" class="mt-1 w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-primary-500" />
        </label>
        <label class="block text-sm">Email
          <input type="email" class="mt-1 w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-primary-500" />
        </label>
        <label class="block text-sm">Número de Funcionários
          <input type="number" class="mt-1 w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-primary-500" />
        </label>
        <div class="flex justify-end gap-3 pt-2">
          <button type="button" onclick="closeModal('empresaModal')" class="px-4 py-2 text-gray-700 border border-gray-300 rounded-lg hover:bg-gray-50">Cancelar</button>
          <button type="submit" class="px-4 py-2 bg-primary-600 text-white rounded-lg hover:bg-primary-700">Salvar</button>
        </div>
      </form>
    </div>
  </div>

  <!-- Modal Protocolo -->
  <div id="protocoloModal" class="fixed inset-0 bg-gray-900/50 hidden items-center justify-center z-50">
    <div class="bg-white rounded-xl shadow-soft p-6 w-full max-w-md mx-4">
      <div class="flex justify-between items-center mb-4">
        <h3 class="text-lg font-semibold">Novo Protocolo</h3>
        <button onclick="closeModal('protocoloModal')" class="text-gray-500 hover:text-gray-700"><i class="fa-solid fa-xmark"></i></button>
      </div>
      <form class="space-y-4">
        <label class="block text-sm">Nome do Protocolo
          <input type="text" class="mt-1 w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-green-500" />
        </label>
        <label class="block text-sm">Descrição
          <textarea class="mt-1 w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-green-500" rows="3"></textarea>
        </label>
        <label class="block text-sm">Categoria
          <select class="mt-1 w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-green-500">
            <option>Estresse</option>
            <option>Ansiedade</option>
            <option>Bem-estar</option>
            <option>Burnout</option>
          </select>
        </label>
        <div class="flex justify-end gap-3 pt-2">
          <button type="button" onclick="closeModal('protocoloModal')" class="px-4 py-2 text-gray-700 border border-gray-300 rounded-lg hover:bg-gray-50">Cancelar</button>
          <button type="submit" class="px-4 py-2 bg-green-600 text-white rounded-lg hover:bg-green-700">Salvar</button>
        </div>
      </form>
    </div>
  </div>

  <script>
    // Helpers
    const qs  = (s, el=document) => el.querySelector(s);
    const qsa = (s, el=document) => [...el.querySelectorAll(s)];

    // Sidebar toggle (mobile)
    const sidebar = qs('#sidebar');
    const backdrop = qs('#backdrop');
    qs('#sidebarToggle').addEventListener('click', () => {
      const open = sidebar.classList.toggle('-translate-x-full');
      // If class present after toggle -> it just became hidden; we want visible when NOT present
      const isVisible = !sidebar.classList.contains('-translate-x-full');
      backdrop.classList.toggle('hidden', !isVisible);
    });
    backdrop.addEventListener('click', () => {
      sidebar.classList.add('-translate-x-full');
      backdrop.classList.add('hidden');
    });

    // User menu
    const userBtn = qs('#userMenuBtn');
    const userMenu = qs('#userMenu');
    userBtn.addEventListener('click', (e) => {
      e.stopPropagation();
      userMenu.classList.toggle('hidden');
    });
    document.addEventListener('click', (e) => {
      if (!userMenu.contains(e.target)) userMenu.classList.add('hidden');
    });

    // Section switching
    function setActive(sectionId){
      qsa('main > section').forEach(sec => sec.classList.toggle('hidden', sec.id !== sectionId));
      qsa('.nav-item').forEach(btn => {
        const active = btn.dataset.section === sectionId;
        btn.classList.toggle('bg-primary-50', active);
        btn.classList.toggle('border', active);
        btn.classList.toggle('border-primary-100', active);
        btn.classList.toggle('text-gray-700', active);
        btn.classList.toggle('text-gray-600', !active);
      });
    }
    qsa('.nav-item').forEach(btn => btn.addEventListener('click', () => setActive(btn.dataset.section)));
    setActive('overview'); // default

    // Modals
    function openModal(id){
      const el = qs('#'+id);
      el.classList.remove('hidden');
      el.classList.add('flex');
    }
    function closeModal(id){
      const el = qs('#'+id);
      el.classList.add('hidden');
      el.classList.remove('flex');
    }
    window.openModal = openModal;
    window.closeModal = closeModal;
  </script>
</body>
</html>
<?php /**PATH /Users/mac/Documents/projetos/AzoProtocolo/resources/views/dashboard-gestao.blade.php ENDPATH**/ ?>