@extends('layouts.gestao')

@section('title', 'Usuários')

@section('content')
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
    {{-- Header / Ações --}}
    <div class="flex flex-col gap-3 sm:flex-row sm:items-center sm:justify-between mt-2">
        <div>
            <h1 class="text-2xl font-semibold tracking-tight text-gray-900">Usuários</h1>
            <p class="text-sm text-gray-500">Gerencie contas, perfis e permissões.</p>
        </div>
        <div class="flex items-center gap-2">
            <form action="{{ route('usuarios.index') }}" method="GET" class="hidden md:block">
                <label class="relative block">
                    <span class="sr-only">Buscar</span>
                    <span class="absolute inset-y-0 left-0 flex items-center pl-3">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 text-gray-400" viewBox="0 0 20 20" fill="currentColor"><path fill-rule="evenodd" d="M9 3.5a5.5 5.5 0 104.473 8.765l3.131 3.131a.75.75 0 101.06-1.06l-3.13-3.132A5.5 5.5 0 009 3.5zm-4 5.5a4 4 0 118 0 4 4 0 01-8 0z" clip-rule="evenodd"/></svg>
                    </span>
                    <input name="q" value="{{ request('q') }}" class="pl-8 pr-3 py-2 rounded-lg border border-gray-200 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent text-sm w-64" placeholder="Buscar por nome ou email" />
                </label>
            </form>
            <a href="{{ route('usuarios.create') }}" class="inline-flex items-center gap-2 bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-lg shadow">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" viewBox="0 0 20 20" fill="currentColor"><path d="M10 3a1 1 0 011 1v5h5a1 1 0 110 2h-5v5a1 1 0 11-2 0v-5H4a1 1 0 110-2h5V4a1 1 0 011-1z"/></svg>
                Novo Usuário
            </a>
        </div>
    </div>

    {{-- Alerts --}}
    @if(session('success'))
        <div x-data="{show:true}" x-show="show" class="mt-4 rounded-lg border border-green-200 bg-green-50 text-green-800 px-4 py-3 flex items-start gap-3">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 mt-0.5" viewBox="0 0 20 20" fill="currentColor"><path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.857-9.809a.75.75 0 00-1.214-.882l-3.182 4.384-1.59-1.59a.75.75 0 10-1.06 1.061l2.25 2.25a.75.75 0 001.145-.089l3.651-5.134z" clip-rule="evenodd"/></svg>
            <div class="text-sm flex-1">{{ session('success') }}</div>
            <button x-on:click="show=false" class="text-green-700/70 hover:text-green-900"><svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" viewBox="0 0 20 20" fill="currentColor"><path fill-rule="evenodd" d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z" clip-rule="evenodd"/></svg></button>
        </div>
    @endif

    {{-- Filtros --}}
    <form action="{{ route('usuarios.index') }}" method="GET" class="mt-4 bg-white border border-gray-200 rounded-xl p-4 shadow-sm">
        <div class="grid grid-cols-1 sm:grid-cols-3 gap-3">
            <div>
                <label class="text-xs font-medium text-gray-600">Buscar</label>
                <input type="text" name="q" value="{{ request('q') }}" class="mt-1 w-full px-3 py-2 rounded-lg border border-gray-200 focus:outline-none focus:ring-2 focus:ring-blue-500" placeholder="Nome ou email" />
            </div>
            <div>
                <label class="text-xs font-medium text-gray-600">Perfil</label>
                <select name="perfil" class="mt-1 w-full px-3 py-2 rounded-lg border border-gray-200 focus:outline-none focus:ring-2 focus:ring-blue-500">
                    <option value="">Todos</option>
                    <option value="admin" @selected(request('perfil')==='admin')>Admin</option>
                    <option value="gestor" @selected(request('perfil')==='gestor')>Gestor</option>
                    <option value="operador" @selected(request('perfil')==='operador')>Operador</option>
                </select>
            </div>
            <div class="flex items-end gap-2">
                <button class="inline-flex items-center gap-2 bg-gray-100 hover:bg-gray-200 text-gray-800 px-4 py-2 rounded-lg">Limpar</button>
                <button class="inline-flex items-center gap-2 bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-lg">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" viewBox="0 0 20 20" fill="currentColor"><path fill-rule="evenodd" d="M3.5 4.75A.75.75 0 014.25 4h11.5a.75.75 0 01.53 1.28l-4.78 4.78v4.69a.75.75 0 01-1.06.67l-3-1.5a.75.75 0 01-.42-.67V10.06l-4.78-4.78A.75.75 0 013.5 4.75z" clip-rule="evenodd"/></svg>
                    Filtrar
                </button>
            </div>
        </div>
    </form>

    {{-- Tabela --}}
    <div class="mt-4 bg-white border border-gray-200 rounded-xl overflow-hidden shadow-sm">
        <div class="px-4 py-3 border-b border-gray-200 flex items-center justify-between">
            <p class="text-sm text-gray-600"></span></p>
            @if(request('q') || request('perfil'))
                <a href="{{ route('usuarios.index') }}" class="text-sm text-blue-600 hover:text-blue-800">Limpar filtros</a>
            @endif
        </div>
        <div class="overflow-x-auto">
            <table class="min-w-full">
                <thead class="bg-gray-50 text-left text-xs font-semibold text-gray-600">
                    <tr>
                        <th class="px-6 py-3">Nome</th>
                        <th class="px-6 py-3">Email</th>
                        <th class="px-6 py-3">Perfil</th>
                        <th class="px-6 py-3 text-right">Ações</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-100">
                    @forelse($users as $user)
                        @php
                            $perfilColor = [
                                'admin' => 'bg-red-100 text-red-700',
                                'gestor' => 'bg-amber-100 text-amber-700',
                                'operador' => 'bg-emerald-100 text-emerald-700',
                            ][$user->perfil] ?? 'bg-gray-100 text-gray-700';
                            $avatar = $user->profile_photo_url ?? 'https://ui-avatars.com/api/?name='.urlencode($user->name).'&size=64&background=E5E7EB&color=111827';
                        @endphp
                        <tr class="hover:bg-gray-50">
                            <td class="px-6 py-4">
                                <div class="flex items-center gap-3">
                                    <img src="{{ $avatar }}" alt="{{ $user->name }}" class="h-9 w-9 rounded-full object-cover ring-1 ring-gray-200" />
                                    <div>
                                        <div class="font-medium text-gray-900">{{ $user->name }}</div>
                                        <div class="text-xs text-gray-500">ID #{{ $user->id }}</div>
                                    </div>
                                </div>
                            </td>
                            <td class="px-6 py-4 text-gray-700">{{ $user->email }}</td>
                            <td class="px-6 py-4">
                                <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium {{ $perfilColor }} capitalize">{{ $user->perfil }}</span>
                            </td>
                            <td class="px-6 py-4">
                                <div class="flex justify-end gap-2">
                                    <a href="{{ route('usuarios.edit', $user) }}" class="inline-flex items-center gap-1.5 px-3 py-1.5 text-sm rounded-lg border border-blue-200 text-blue-700 hover:bg-blue-50">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" viewBox="0 0 20 20" fill="currentColor"><path d="M13.586 3.586a2 2 0 112.828 2.828l-.793.793-2.828-2.828.793-.793zM11.379 5.793L4 13.172V16h2.828l7.38-7.379-2.83-2.828z"/></svg>
                                        Editar
                                    </a>
                                    <form action="{{ route('usuarios.destroy', $user) }}" method="POST" onsubmit="return confirm('Deseja excluir este usuário?')">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="inline-flex items-center gap-1.5 px-3 py-1.5 text-sm rounded-lg border border-red-200 text-red-700 hover:bg-red-50">
                                            <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" viewBox="0 0 20 20" fill="currentColor"><path fill-rule="evenodd" d="M9 2a1 1 0 00-.894.553L7.382 4H4a1 1 0 100 2h.293l.853 10.236A2 2 0 007.139 18h5.722a2 2 0 001.993-1.764L15.707 6H16a1 1 0 100-2h-3.382l-.724-1.447A1 1 0 0011 2H9zm-1 6a1 1 0 112 0v6a1 1 0 11-2 0V8zm5 0a1 1 0 112 0v6a1 1 0 11-2 0V8z" clip-rule="evenodd"/></svg>
                                            Excluir
                                        </button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="4" class="px-6 py-16">
                                <div class="text-center">
                                    <div class="inline-flex h-12 w-12 items-center justify-center rounded-full bg-gray-100 text-gray-400">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" viewBox="0 0 24 24" fill="currentColor"><path d="M16 11c1.657 0 3 1.343 3 3v4h1a1 1 0 110 2H4a1 1 0 110-2h1v-4c0-1.657 1.343-3 3-3h8zm-4-8a4 4 0 110 8 4 4 0 010-8z"/></svg>
                                    </div>
                                    <h3 class="mt-3 text-sm font-semibold text-gray-900">Nenhum usuário encontrado</h3>
                                    <p class="mt-1 text-sm text-gray-500">Tente alterar os filtros ou crie um novo usuário.</p>
                                    <div class="mt-4">
                                        <a href="{{ route('usuarios.create') }}" class="inline-flex items-center gap-2 bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-lg">Novo Usuário</a>
                                    </div>
                                </div>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        {{-- Paginação --}}
        @if(method_exists($users, 'links'))
            <div class="px-4 py-3 border-t border-gray-200 bg-gray-50">
                {{ $users->withQueryString()->links() }}
            </div>
        @endif
    </div>
</div>
@endsection
