@extends('layouts.empresas')

@section('title', 'Relatórios')

@section('content')
  <form method="GET" action="{{ route('relatorios.index') }}" class="mb-6 flex flex-wrap gap-2 items-end">
    <div>
      <label class="block text-sm text-gray-600 mb-1">Protocolo</label>
      <select name="protocolo_id" class="border-gray-300 rounded-lg">
        <option value="" @selected(!$protocoloId)>Selecione</option>
        @foreach($protocolos as $prot)
          <option value="{{ $prot->id }}" @selected($prot->id == $protocoloId)>{{ $prot->nome }}</option>
        @endforeach
      </select>
    </div>
    @if($periodos->isNotEmpty())
      <div>
        <label class="block text-sm text-gray-600 mb-1">Período</label>
        <select name="periodo_id" class="border-gray-300 rounded-lg">
          <option value="" @selected(!$periodoId)>Selecione</option>
          @foreach($periodos as $per)
            <option value="{{ $per->id }}" @selected($per->id == $periodoId)>{{ $per->inicio->format('d/m/Y') }} - {{ $per->fim->format('d/m/Y') }}</option>
          @endforeach
        </select>
      </div>
    @endif
    <div>
      <button type="submit" class="px-4 py-2 bg-primary-600 text-white rounded-lg">Gerar Relatório</button>
    </div>
  </form>

  @if(!empty($analitico))
    <div class="space-y-6">
      @foreach($analitico as $pergunta)
        <div class="bg-white rounded-xl border border-gray-200 p-5 shadow-soft">
          <h3 class="font-semibold mb-4">{{ $pergunta['texto'] }}</h3>
          <ul class="space-y-2">
            @foreach($pergunta['opcoes'] as $opcao)
              <li class="flex justify-between text-sm text-gray-600">
                <span>{{ $opcao['texto'] }}</span>
                <span>{{ $opcao['quantidade'] }}</span>
              </li>
            @endforeach
          </ul>
        </div>
      @endforeach
    </div>
  @elseif($protocoloId && $periodoId)
    <p class="text-sm text-gray-500">Sem respostas para os filtros selecionados.</p>
  @endif
@endsection
