@csrf
@if(isset($protocolo))
    @method('PUT')
@endif
<div class="grid grid-cols-1 gap-4">
    <div>
        <label for="nome" class="block text-sm font-medium text-gray-700">Nome <span class="text-red-600">*</span></label>
        <input id="nome" name="nome" type="text" value="{{ old('nome', $protocolo->nome ?? '') }}" required class="w-full rounded-lg border border-gray-300 px-3 py-2">
    </div>
    <div>
        <label for="introducao" class="block text-sm font-medium text-gray-700">Texto de Introdução</label>
        <textarea id="introducao" name="introducao" class="w-full rounded-lg border border-gray-300 px-3 py-2" rows="3">{{ old('introducao', $protocolo->introducao ?? '') }}</textarea>
    </div>
    <div>
        <label for="status" class="block text-sm font-medium text-gray-700">Status <span class="text-red-600">*</span></label>
        <select id="status" name="status" class="w-full rounded-lg border border-gray-300 px-3 py-2">
            <option value="1" {{ old('status', $protocolo->status ?? true) ? 'selected' : '' }}>Ativo</option>
            <option value="0" {{ old('status', $protocolo->status ?? true) ? '' : 'selected' }}>Inativo</option>
        </select>
    </div>
    <div>
        <label for="categoria" class="block text-sm font-medium text-gray-700">Tipo <span class="text-red-600">*</span></label>
        <select id="categoria" name="categoria" class="w-full rounded-lg border border-gray-300 px-3 py-2">
            <option value="protocolo" {{ old('categoria', $protocolo->categoria ?? 'protocolo') === 'protocolo' ? 'selected' : '' }}>Protocolo</option>
            <option value="pesquisa" {{ old('categoria', $protocolo->categoria ?? 'protocolo') === 'pesquisa' ? 'selected' : '' }}>Pesquisa</option>
        </select>
    </div>
    <div>
        <label for="visivel_empresas" class="block text-sm font-medium text-gray-700">Visível para empresas <span class="text-red-600">*</span></label>
        <select id="visivel_empresas" name="visivel_empresas" class="w-full rounded-lg border border-gray-300 px-3 py-2">
            <option value="1" {{ old('visivel_empresas', $protocolo->visivel_empresas ?? true) ? 'selected' : '' }}>Sim</option>
            <option value="0" {{ old('visivel_empresas', $protocolo->visivel_empresas ?? true) ? '' : 'selected' }}>Não</option>
        </select>
    </div>
    <div>
        <label for="tipo" class="block text-sm font-medium text-gray-700">Tipo de pontuação <span class="text-red-600">*</span></label>
        <select id="tipo" name="tipo" class="w-full rounded-lg border border-gray-300 px-3 py-2">
            <option value="simples" {{ old('tipo', $protocolo->tipo ?? '') === 'simples' ? 'selected' : '' }}>Simples</option>
            <option value="par_impar" {{ old('tipo', $protocolo->tipo ?? '') === 'par_impar' ? 'selected' : '' }}>Par/Ímpar</option>
        </select>
    </div>
    <div class="flex items-center gap-2">
        <input id="permitir_pf" name="permitir_pf" type="checkbox" value="1" {{ old('permitir_pf', $protocolo->permitir_pf ?? false) ? 'checked' : '' }} class="rounded border-gray-300 text-blue-600 focus:ring-blue-500">
        <label for="permitir_pf" class="text-sm font-medium text-gray-700">Permitir PF</label>
    </div>
</div>

<div class="mt-6">
    <h2 class="text-base font-semibold text-gray-900">Resultados</h2>
    @php
        $resultados = old('resultados', isset($protocolo) ? $protocolo->resultados->toArray() : [[]]);
    @endphp
    <div id="resultados-container" class="space-y-4 mt-4">
        @foreach($resultados as $i => $resultado)
            <div class="resultado flex flex-col gap-2 bg-gray-50 p-4 rounded-lg">
                <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Pontuação De</label>
                        <input type="number" name="resultados[{{ $i }}][pontuacao_de]" value="{{ $resultado['pontuacao_de'] ?? '' }}" class="w-full rounded-lg border border-gray-300 px-3 py-2">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Pontuação Até</label>
                        <input type="number" name="resultados[{{ $i }}][pontuacao_ate]" value="{{ $resultado['pontuacao_ate'] ?? '' }}" class="w-full rounded-lg border border-gray-300 px-3 py-2">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Rótulo</label>
                        <input type="text" name="resultados[{{ $i }}][rotulo]" value="{{ $resultado['rotulo'] ?? '' }}" class="w-full rounded-lg border border-gray-300 px-3 py-2">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Paridade</label>
                        <select name="resultados[{{ $i }}][paridade]" class="w-full rounded-lg border border-gray-300 px-3 py-2">
                            <option value="geral" {{ ($resultado['paridade'] ?? '') === 'geral' ? 'selected' : '' }}>Geral</option>
                            <option value="par" {{ ($resultado['paridade'] ?? '') === 'par' ? 'selected' : '' }}>Par</option>
                            <option value="impar" {{ ($resultado['paridade'] ?? '') === 'impar' ? 'selected' : '' }}>Ímpar</option>
                        </select>
                    </div>
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700">Texto</label>
                    <textarea name="resultados[{{ $i }}][texto]" class="w-full rounded-lg border border-gray-300 px-3 py-2" rows="2">{{ $resultado['texto'] ?? '' }}</textarea>
                </div>
            </div>
        @endforeach
    </div>
    <button type="button" id="add-resultado" class="mt-2 inline-flex items-center gap-2 text-sm px-3 py-2 rounded-lg border border-gray-200 text-gray-700 hover:bg-gray-50">Adicionar Resultado</button>
</div>

<div class="pt-4 border-t border-gray-200 flex items-center justify-end gap-2">
    <a href="{{ route('protocolos.index') }}" class="inline-flex items-center gap-2 text-sm px-4 py-2 rounded-lg border border-gray-200 text-gray-700 hover:bg-gray-50">Cancelar</a>
    <button type="submit" class="inline-flex items-center gap-2 text-sm px-4 py-2 rounded-lg bg-green-600 text-white hover:bg-green-700">Salvar</button>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        let index = {{ count($resultados) }};
        const container = document.getElementById('resultados-container');
        document.getElementById('add-resultado').addEventListener('click', function () {
            const div = document.createElement('div');
            div.classList.add('resultado','flex','flex-col','gap-2','bg-gray-50','p-4','rounded-lg');
            div.innerHTML = `
                <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Pontuação De</label>
                        <input type="number" name="resultados[${index}][pontuacao_de]" class="w-full rounded-lg border border-gray-300 px-3 py-2">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Pontuação Até</label>
                        <input type="number" name="resultados[${index}][pontuacao_ate]" class="w-full rounded-lg border border-gray-300 px-3 py-2">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Rótulo</label>
                        <input type="text" name="resultados[${index}][rotulo]" class="w-full rounded-lg border border-gray-300 px-3 py-2">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Paridade</label>
                        <select name="resultados[${index}][paridade]" class="w-full rounded-lg border border-gray-300 px-3 py-2">
                            <option value="geral">Geral</option>
                            <option value="par">Par</option>
                            <option value="impar">Ímpar</option>
                        </select>
                    </div>
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700">Texto</label>
                    <textarea name="resultados[${index}][texto]" class="w-full rounded-lg border border-gray-300 px-3 py-2" rows="2"></textarea>
                </div>`;
            container.appendChild(div);
            index++;
        });
    });
</script>
