@extends(auth('empresa')->check() ? 'layouts.empresas' : 'layouts.gestao')

@section('title', 'Setores')

@section('content')
<div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
    <div class="flex items-center justify-between mt-2">
        <div>
            <h1 class="text-2xl font-semibold tracking-tight text-gray-900">Setores de {{ $empresa->name }}</h1>
            <p class="text-sm text-gray-500">Gerencie os setores da empresa.</p>
        </div>
        <a href="{{ route('empresas.setores.create', $empresa) }}" class="inline-flex items-center gap-2 bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-lg shadow">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" viewBox="0 0 20 20" fill="currentColor"><path d="M10 3a1 1 0 011 1v5h5a1 1 0 110 2h-5v5a1 1 0 11-2 0v-5H4a1 1 0 110-2h5V4a1 1 0 011-1z"/></svg>
            Novo Setor
        </a>
    </div>

    @if(session('success'))
        <div class="mt-4 rounded-lg border border-green-200 bg-green-50 text-green-800 px-4 py-3">{{ session('success') }}</div>
    @endif

    <div class="mt-4 bg-white border border-gray-200 rounded-xl overflow-hidden shadow-sm">
        <table class="min-w-full">
            <thead class="bg-gray-50 text-left text-xs font-semibold text-gray-600">
                <tr>
                    <th class="px-6 py-3">Nome</th>
                    <th class="px-6 py-3 text-right">Ações</th>
                </tr>
            </thead>
            <tbody class="divide-y divide-gray-100">
                @forelse($setores as $setor)
                <tr class="hover:bg-gray-50">
                    <td class="px-6 py-4 text-gray-900">{{ $setor->nome }}</td>
                    <td class="px-6 py-4">
                        <div class="flex justify-end gap-2">
                            <a href="{{ route('empresas.setores.edit', [$empresa, $setor]) }}" class="inline-flex items-center gap-1.5 px-3 py-1.5 text-sm rounded-lg border border-blue-200 text-blue-700 hover:bg-blue-50">Editar</a>
                            <form action="{{ route('empresas.setores.destroy', [$empresa, $setor]) }}" method="POST" onsubmit="return confirm('Deseja excluir este setor?')">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="inline-flex items-center gap-1.5 px-3 py-1.5 text-sm rounded-lg border border-red-200 text-red-700 hover:bg-red-50">Excluir</button>
                            </form>
                        </div>
                    </td>
                </tr>
                @empty
                <tr>
                    <td colspan="2" class="px-6 py-16 text-center text-sm text-gray-500">Nenhum setor encontrado.</td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>
</div>
@endsection
