@extends(auth('empresa')->check() ? 'layouts.empresas' : 'layouts.gestao')

@section('title', 'Editar Setor')

@section('content')
<div class="max-w-md mx-auto px-4 sm:px-6 lg:px-8">
    <div class="flex items-center gap-2 text-sm text-gray-500">
        @if(auth('empresa')->check())
            <a href="{{ route('empresas.setores.index', $empresa) }}" class="hover:text-gray-700">Setores</a>
            <span>/</span>
            <span class="text-gray-700">Editar</span>
        @else
            <a href="{{ route('empresas.index') }}" class="hover:text-gray-700">Empresas</a>
            <span>/</span>
            <a href="{{ route('empresas.setores.index', $empresa) }}" class="hover:text-gray-700">Setores</a>
            <span>/</span>
            <span class="text-gray-700">Editar</span>
        @endif
    </div>

    <div class="mt-2 flex items-center justify-between">
        <div>
            <h1 class="text-2xl font-semibold tracking-tight text-gray-900">Editar Setor</h1>
        </div>
    </div>

    @if($errors->any())
        <div class="mt-4 rounded-lg border border-red-200 bg-red-50 text-red-800 px-4 py-3">
            <ul class="list-disc list-inside text-sm">
                @foreach($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <div class="mt-4 bg-white border border-gray-200 rounded-xl shadow-sm overflow-hidden">
        <form method="POST" action="{{ route('empresas.setores.update', [$empresa, $setor]) }}" class="px-4 sm:px-6 py-6 space-y-6">
            @csrf
            @method('PUT')
            <div>
                <label for="nome" class="block text-sm font-medium text-gray-700">Nome</label>
                <input id="nome" name="nome" type="text" required value="{{ old('nome', $setor->nome) }}" class="mt-1 w-full rounded-lg border border-gray-300 px-3 py-2 focus:outline-none focus:ring-2 focus:ring-blue-500">
            </div>
            <div class="pt-4 border-t border-gray-200 flex items-center justify-end gap-2">
                <a href="{{ route('empresas.setores.index', $empresa) }}" class="inline-flex items-center gap-2 text-sm px-4 py-2 rounded-lg border border-gray-200 text-gray-700 hover:bg-gray-50">Cancelar</a>
                <button type="submit" class="inline-flex items-center gap-2 text-sm px-4 py-2 rounded-lg bg-blue-600 text-white hover:bg-blue-700">Salvar</button>
            </div>
        </form>
    </div>
</div>
@endsection
