@extends('layouts.gestao')

@section('title', 'Editar Empresa')

@section('content')
<div class="max-w-3xl mx-auto px-4 sm:px-6 lg:px-8">
    <div class="flex items-center gap-2 text-sm text-gray-500">
        <a href="{{ route('empresas.index') }}" class="hover:text-gray-700">Empresas</a>
        <span>/</span>
        <span class="text-gray-700">Editar</span>
    </div>

    <div class="mt-2 flex items-center justify-between">
        <div>
            <h1 class="text-2xl font-semibold tracking-tight text-gray-900">Editar Empresa</h1>
            <p class="text-sm text-gray-500">Atualize os dados cadastrais. Deixe a senha em branco para manter a atual.</p>
        </div>
        <a href="{{ route('empresas.index') }}" class="hidden sm:inline-flex items-center gap-2 text-sm px-3 py-2 rounded-lg border border-gray-200 text-gray-700 hover:bg-gray-50">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" viewBox="0 0 20 20" fill="currentColor"><path fill-rule="evenodd" d="M7.78 4.22a.75.75 0 010 1.06L4.56 8.5H17a.75.75 0 010 1.5H4.56l3.22 3.22a.75.75 0 11-1.06 1.06l-4.5-4.5a.75.75 0 010-1.06l4.5-4.5a.75.75 0 011.06 0z" clip-rule="evenodd"/></svg>
            Voltar
        </a>
    </div>

    @if($errors->any())
        <div class="mt-4 rounded-lg border border-red-200 bg-red-50 text-red-800 px-4 py-3">
            <div class="font-medium">Ocorreram erros ao enviar o formulário:</div>
            <ul class="mt-2 list-disc list-inside text-sm">
                @foreach($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <div class="mt-4 bg-white border border-gray-200 rounded-xl shadow-sm overflow-hidden">
        <div class="px-4 sm:px-6 py-4 border-b border-gray-200">
            <h2 class="text-base font-semibold text-gray-900">Dados da empresa</h2>
            <p class="text-sm text-gray-500">Campos obrigatórios marcados com <span class="text-red-600">*</span>.</p>
        </div>

        <form method="POST" action="{{ route('empresas.update', $empresa) }}" class="px-4 sm:px-6 py-6 space-y-6" autocomplete="off" novalidate>
            @csrf
            @method('PUT')
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                <div>
                    <label for="name" class="block text-sm font-medium text-gray-700">Nome <span class="text-red-600">*</span></label>
                    <div class="mt-1">
                        <input id="name" name="name" type="text" required value="{{ old('name', $empresa->name) }}" autocomplete="organization" class="w-full rounded-lg border border-gray-300 px-3 py-2 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent {{ $errors->has('name') ? 'ring-2 ring-red-500 border-transparent' : '' }}">
                        @if($errors->has('name'))
                            <p class="mt-1 text-xs text-red-600">{{ $errors->first('name') }}</p>
                        @else
                            <p class="mt-1 text-xs text-gray-500">Nome da empresa.</p>
                        @endif
                    </div>
                </div>

                <div>
                    <label for="email" class="block text-sm font-medium text-gray-700">Email <span class="text-red-600">*</span></label>
                    <div class="mt-1">
                        <input id="email" name="email" type="email" required value="{{ old('email', $empresa->email) }}" autocomplete="email" class="w-full rounded-lg border border-gray-300 px-3 py-2 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent {{ $errors->has('email') ? 'ring-2 ring-red-500 border-transparent' : '' }}">
                        @if($errors->has('email'))
                            <p class="mt-1 text-xs text-red-600">{{ $errors->first('email') }}</p>
                        @else
                            <p class="mt-1 text-xs text-gray-500">Será usado para login.</p>
                        @endif
                    </div>
                </div>

                <div>
                    <label for="contact_name" class="block text-sm font-medium text-gray-700">Nome do Contato</label>
                    <div class="mt-1">
                        <input id="contact_name" name="contact_name" type="text" value="{{ old('contact_name', $empresa->contact_name) }}" class="w-full rounded-lg border border-gray-300 px-3 py-2 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                    </div>
                </div>

                <div>
                    <label for="phone" class="block text-sm font-medium text-gray-700">Telefone</label>
                    <div class="mt-1">
                        <input id="phone" name="phone" type="text" value="{{ old('phone', $empresa->phone) }}" class="w-full rounded-lg border border-gray-300 px-3 py-2 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                    </div>
                </div>

                <div>
                    <label for="city" class="block text-sm font-medium text-gray-700">Cidade</label>
                    <div class="mt-1">
                        <input id="city" name="city" type="text" value="{{ old('city', $empresa->city) }}" class="w-full rounded-lg border border-gray-300 px-3 py-2 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                    </div>
                </div>

                <div>
                    <label for="state" class="block text-sm font-medium text-gray-700">Estado</label>
                    <div class="mt-1">
                        <input id="state" name="state" type="text" maxlength="2" value="{{ old('state', $empresa->state) }}" class="w-full rounded-lg border border-gray-300 px-3 py-2 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                    </div>
                </div>

                <div class="md:col-span-1">
                    <label for="password" class="block text-sm font-medium text-gray-700">Senha</label>
                    <div class="mt-1 relative">
                        <input id="password" name="password" type="password" autocomplete="new-password" placeholder="Deixe em branco para manter" class="w-full rounded-lg border border-gray-300 px-3 py-2 pr-10 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent {{ $errors->has('password') ? 'ring-2 ring-red-500 border-transparent' : '' }}">
                        <button type="button" data-toggle-password="password" class="absolute inset-y-0 right-0 px-3 text-gray-500 hover:text-gray-700" tabindex="-1">
                            <svg class="h-5 w-5" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M1 12s4-8 11-8 11 8 11 8-4 8-11 8S1 12 1 12Z"/><circle cx="12" cy="12" r="3"/></svg>
                        </button>
                        @if($errors->has('password'))
                            <p class="mt-1 text-xs text-red-600">{{ $errors->first('password') }}</p>
                        @else
                            <p class="mt-1 text-xs text-gray-500">Mín. 6 caracteres.</p>
                        @endif
                    </div>
                </div>

                <div class="md:col-span-1">
                    <label for="password_confirmation" class="block text-sm font-medium text-gray-700">Confirmar Senha</label>
                    <div class="mt-1 relative">
                        <input id="password_confirmation" name="password_confirmation" type="password" autocomplete="new-password" placeholder="Repita a nova senha" class="w-full rounded-lg border border-gray-300 px-3 py-2 pr-10 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                        <button type="button" data-toggle-password="password_confirmation" class="absolute inset-y-0 right-0 px-3 text-gray-500 hover:text-gray-700" tabindex="-1">
                            <svg class="h-5 w-5" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M1 12s4-8 11-8 11 8 11 8-4 8-11 8S1 12 1 12Z"/><path d="M3 3l18 18"/></svg>
                        </button>
                    </div>
                </div>
            </div>

            <div class="pt-4 border-t border-gray-200 flex items-center justify-end gap-2">
                <a href="{{ route('empresas.index') }}" class="inline-flex items-center gap-2 text-sm px-4 py-2 rounded-lg border border-gray-200 text-gray-700 hover:bg-gray-50">Cancelar</a>
                <button type="submit" class="inline-flex items-center gap-2 text-sm px-4 py-2 rounded-lg bg-blue-600 text-white hover:bg-blue-700">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" viewBox="0 0 20 20" fill="currentColor"><path d="M17 8a1 1 0 00-1 1v5H4V6h5a1 1 0 000-2H4a2 2 0 00-2 2v10a2 2 0 002 2h12a2 2 0 002-2V9a1 1 0 00-1-1z"/><path d="M19 4a1 1 0 00-1-1h-4a1 1 0 00-.707.293l-8 8A1 1 0 005 12v2h2a1 1 0 00.707-.293l8-8A1 1 0 0016 5h2a1 1 0 001-1z"/></svg>
                    Atualizar
                </button>
            </div>
        </form>
    </div>

    <script>
      document.querySelectorAll('[data-toggle-password]').forEach(btn => {
        btn.addEventListener('click', () => {
          const id = btn.getAttribute('data-toggle-password');
          const input = document.getElementById(id);
          if (!input) return;
          input.type = input.type === 'password' ? 'text' : 'password';
        });
      });
    </script>
</div>
@endsection
