@extends('layouts.empresas')

@section('title', 'Visualização de Resultados')

@section('content')
  <form method="GET" action="{{ url()->current() }}" class="mb-6 flex gap-2">
    <select name="protocolo_id" onchange="this.form.submit()" class="border-gray-300 rounded-lg">
      <option value="" @selected(!$protocoloId)>Todos</option>
      @foreach($protocolos as $prot)
        <option value="{{ $prot->id }}" @selected($prot->id == $protocoloId)>{{ $prot->nome }}</option>
      @endforeach
    </select>
    @if($periodos->isNotEmpty())
      <select name="periodo_id" onchange="this.form.submit()" class="border-gray-300 rounded-lg">
        <option value="" @selected(!$periodoId)>Todos</option>
        @foreach($periodos as $per)
          <option value="{{ $per->id }}" @selected($per->id == $periodoId)>
            {{ $per->inicio->format('d/m/Y') }} - {{ $per->fim->format('d/m/Y') }}
          </option>
        @endforeach
      </select>
    @endif
  </form>

  <section class="grid grid-cols-1 md:grid-cols-2 xl:grid-cols-4 gap-4 sm:gap-6">
    <div class="bg-white rounded-xl border border-gray-200 p-5 shadow-soft">
      <div class="flex items-center gap-4">
        <span class="p-3 rounded-xl bg-green-50 text-green-600"><i class="fa-solid fa-face-smile text-lg"></i></span>
        <div>
          <p class="text-sm text-gray-600">Pontuação Média</p>
          <p class="text-2xl font-semibold">{{ $mediaPontuacao }}</p>
        </div>
      </div>
    </div>
    <div class="bg-white rounded-xl border border-gray-200 p-5 shadow-soft">
      <div class="flex items-center gap-4">
        <span class="p-3 rounded-xl bg-yellow-50 text-yellow-600"><i class="fa-solid fa-list-check text-lg"></i></span>
        <div>
          <p class="text-sm text-gray-600">Total de Respostas</p>
          <p class="text-2xl font-semibold">{{ $totalRespostas }}</p>
        </div>
      </div>
    </div>
    <div class="bg-white rounded-xl border border-gray-200 p-5 shadow-soft">
      <div class="flex items-center gap-4">
        <span class="p-3 rounded-xl bg-primary-50 text-primary-600"><i class="fa-solid fa-arrow-up text-lg"></i></span>
        <div>
          <p class="text-sm text-gray-600">Pontuação Máxima</p>
          <p class="text-2xl font-semibold">{{ $maxPontuacao }}</p>
        </div>
      </div>
    </div>
    <div class="bg-white rounded-xl border border-gray-200 p-5 shadow-soft">
      <div class="flex items-center gap-4">
        <span class="p-3 rounded-xl bg-purple-50 text-purple-600"><i class="fa-solid fa-arrow-down text-lg"></i></span>
        <div>
          <p class="text-sm text-gray-600">Pontuação Mínima</p>
          <p class="text-2xl font-semibold">{{ $minPontuacao }}</p>
        </div>
      </div>
    </div>
  </section>

  <section class="grid grid-cols-1 xl:grid-cols-2 gap-6 mt-6">
    <div class="bg-white rounded-xl border border-gray-200 p-5 shadow-soft">
      <div class="flex items-center justify-between mb-4">
        <h3 class="text-base font-semibold">Pontuação ao Longo do Tempo</h3>
      </div>
      <div class="h-72"><canvas id="bemestarChart"></canvas></div>
    </div>
    <div class="bg-white rounded-xl border border-gray-200 p-5 shadow-soft">
      <div class="flex items-center justify-between mb-4">
        <h3 class="text-base font-semibold">Distribuição por Categoria</h3>
      </div>
      <div class="h-72"><canvas id="categoriaChart"></canvas></div>
      @if(!empty($categoriaLabels))
        <div class="mt-4 flex flex-wrap gap-4">
          @foreach($categoriaLabels as $i => $label)
            <span class="text-sm text-gray-600">{{ $label }}: {{ $categoriaPercent[$i] }}% ({{ $categoriaData[$i] }})</span>
          @endforeach
        </div>
      @endif
    </div>
  </section>

  <section class="grid grid-cols-1 xl:grid-cols-3 gap-6 mt-6">
    <div class="bg-white rounded-xl border border-gray-200 p-5 shadow-soft">
      <h3 class="text-base font-semibold mb-4">Respostas por Mês</h3>
      <div class="h-60"><canvas id="estresseChart"></canvas></div>
    </div>
    <div class="bg-white rounded-xl border border-gray-200 p-5 shadow-soft xl:col-span-2">
      <h3 class="text-base font-semibold mb-4">Participação por Departamento</h3>
      <div class="space-y-4">
        @forelse($departamentos as $dep)
          <div class="flex items-center justify-between">
            <span class="text-sm text-gray-600">{{ $dep['nome'] }}</span>
            <div class="flex items-center">
              <div class="w-40 h-2 bg-gray-200 rounded-full">
                <div class="h-2 bg-primary-600 rounded-full" style="width:{{ $dep['percent'] }}%"></div>
              </div>
              <span class="ml-3 text-sm text-gray-600">{{ $dep['percent'] }}%</span>
            </div>
          </div>
        @empty
          <p class="text-sm text-gray-500">Sem respostas registradas</p>
        @endforelse
      </div>
    </div>
  </section>

  <section class="bg-white rounded-xl border border-gray-200 p-5 shadow-soft mt-6">
    <h3 class="text-base font-semibold mb-4">Média por Departamento</h3>
    <div class="h-72"><canvas id="departamentoChart"></canvas></div>
  </section>
@endsection

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.1"></script>
<script>
  const bemestarCtx = document.getElementById('bemestarChart');
  new Chart(bemestarCtx, {
    type: 'line',
    data: {
      labels: @json($lineLabels),
      datasets: [{
        label: 'Pontuação média',
        data: @json($lineData),
        borderColor: '#3b82f6',
        backgroundColor: 'rgba(59,130,246,0.1)',
        tension: 0.4
      }]
    }
  });

  const categoriaCtx = document.getElementById('categoriaChart');
  new Chart(categoriaCtx, {
    type: 'doughnut',
    data: {
      labels: @json($categoriaLabels),
      datasets: [{
        data: @json($categoriaPercent),
        backgroundColor: ['#10b981','#3b82f6','#ef4444','#8b5cf6','#f59e0b']
      }]
    }
  });

  const estresseCtx = document.getElementById('estresseChart');
  new Chart(estresseCtx, {
    type: 'bar',
    data: {
      labels: @json($barLabels),
      datasets: [{
        label: 'Respostas',
        data: @json($barData),
        backgroundColor: '#f59e0b'
      }]
    }
  });

  const departamentoCtx = document.getElementById('departamentoChart');
  new Chart(departamentoCtx, {
    type: 'line',
    data: {
      labels: @json($departamentoLabels),
      datasets: @json($departamentoSeries)
    }
  });
</script>
@endpush
