<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Registrar</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="min-h-screen bg-gray-100 flex items-center justify-center">
    <form method="POST" action="{{ route('register') }}" class="bg-white p-6 rounded shadow-md w-full max-w-md space-y-4">
        @csrf
        <div>
            <label class="block text-sm font-medium text-gray-700">Nome</label>
            <input type="text" name="name" class="mt-1 block w-full border-gray-300 rounded-md" required>
        </div>
        <div>
            <label class="block text-sm font-medium text-gray-700">Email</label>
            <input type="email" name="email" class="mt-1 block w-full border-gray-300 rounded-md" required>
        </div>
        <div>
            <label class="block text-sm font-medium text-gray-700">Senha</label>
            <input type="password" name="password" class="mt-1 block w-full border-gray-300 rounded-md" required>
        </div>
        <div>
            <label class="block text-sm font-medium text-gray-700">Confirmar Senha</label>
            <input type="password" name="password_confirmation" class="mt-1 block w-full border-gray-300 rounded-md" required>
        </div>
        <div>
            <label class="block text-sm font-medium text-gray-700">Perfil</label>
            <select name="perfil" class="mt-1 block w-full border-gray-300 rounded-md" required>
                <option value="operador">Operador</option>
                <option value="admin">Administrador</option>
            </select>
        </div>
        <button type="submit" class="w-full py-2 bg-blue-600 text-white rounded-md">Registrar</button>
    </form>
</body>
</html>
