<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('protocolos', function (Blueprint $table) {
            $table->enum('categoria', ['protocolo', 'pesquisa'])->default('protocolo')->after('tipo');
            $table->boolean('visivel_empresas')->default(true)->after('categoria');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('protocolos', function (Blueprint $table) {
            $table->dropColumn(['categoria', 'visivel_empresas']);
        });
    }
};
