<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('empresa_protocolo_periodos', function (Blueprint $table) {
            $table->id();
            $table->foreignId('empresa_protocolo_id')->constrained('empresa_protocolo')->onDelete('cascade');
            $table->date('inicio');
            $table->date('fim');
            $table->uuid('token')->unique();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('empresa_protocolo_periodos');
    }
};
