<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('protocolo_respostas', function (Blueprint $table) {
            $table->foreignId('setor_id')->nullable()->constrained('setores')->nullOnDelete();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('protocolo_respostas', function (Blueprint $table) {
            $table->dropConstrainedForeignId('setor_id');
        });
    }
};
