<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('empresa_protocolo', function (Blueprint $table) {
            $table->id();
            $table->foreignId('empresa_id')->constrained()->onDelete('cascade');
            $table->foreignId('protocolo_id')->constrained()->onDelete('cascade');
            $table->boolean('ativo')->default(false);
            $table->string('token')->nullable()->unique();
            $table->timestamps();
            $table->unique(['empresa_id', 'protocolo_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('empresa_protocolo');
    }
};
