<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('protocolo_resultados', function (Blueprint $table) {
            $table->id();
            $table->foreignId('protocolo_id')->constrained()->onDelete('cascade');
            $table->integer('pontuacao_de');
            $table->integer('pontuacao_ate');
            $table->string('rotulo');
            $table->text('texto');
            $table->enum('paridade', ['geral', 'par', 'impar'])->default('geral');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('protocolo_resultados');
    }
};
