<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ProtocoloResposta extends Model
{
    protected $fillable = [
        'empresa_id',
        'protocolo_id',
        'nome',
        'cpf',
        'compartilhar',
        'respostas',
        'pontuacao_total',
        'pontuacao_par',
        'pontuacao_impar',
        'setor_id',
        'empresa_protocolo_periodo_id',
    ];

    protected $casts = [
        'compartilhar' => 'boolean',
        'respostas' => 'array',
    ];

    public function protocolo()
    {
        return $this->belongsTo(Protocolo::class);
    }

    public function empresa()
    {
        return $this->belongsTo(Empresa::class);
    }

    public function setor()
    {
        return $this->belongsTo(Setor::class);
    }

    public function periodo()
    {
        return $this->belongsTo(EmpresaProtocoloPeriodo::class, 'empresa_protocolo_periodo_id');
    }
}
