<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Protocolo extends Model
{
    protected $fillable = [
        'nome',
        'introducao',
        'status',
        'tipo',
        'permitir_pf',
        'categoria',
        'visivel_empresas',
    ];

    protected $casts = [
        'status' => 'boolean',
        'permitir_pf' => 'boolean',
        'visivel_empresas' => 'boolean',
    ];

    public function resultados()
    {
        return $this->hasMany(ProtocoloResultado::class);
    }

    public function perguntas()
    {
        return $this->hasMany(Pergunta::class)->orderBy('ordem');
    }

    public function empresas()
    {
        return $this->belongsToMany(Empresa::class, 'empresa_protocolo')
            ->withPivot(['ativo', 'token'])
            ->withTimestamps();
    }
}
