<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class EmpresaProtocolo extends Model
{
    protected $table = 'empresa_protocolo';

    protected $fillable = [
        'empresa_id',
        'protocolo_id',
        'ativo',
        'token',
    ];

    protected $casts = [
        'ativo' => 'boolean',
    ];

    public function empresa()
    {
        return $this->belongsTo(Empresa::class);
    }

    public function protocolo()
    {
        return $this->belongsTo(Protocolo::class);
    }

    public function periodos()
    {
        return $this->hasMany(EmpresaProtocoloPeriodo::class);
    }
}
