<?php

namespace App\Http\Controllers;

use App\Models\Empresa;
use App\Models\Setor;
use Illuminate\Http\Request;

class SetorController extends Controller
{
    public function index(Empresa $empresa)
    {
        $setores = $empresa->setores;
        return view('empresas.setores.index', compact('empresa', 'setores'));
    }

    public function create(Empresa $empresa)
    {
        return view('empresas.setores.create', compact('empresa'));
    }

    public function store(Request $request, Empresa $empresa)
    {
        $data = $request->validate([
            'nome' => ['required', 'string', 'max:255'],
        ]);
        $empresa->setores()->create($data);
        return redirect()->route('empresas.setores.index', $empresa)->with('success', 'Setor criado com sucesso.');
    }

    public function edit(Empresa $empresa, Setor $setor)
    {
        return view('empresas.setores.edit', compact('empresa', 'setor'));
    }

    public function update(Request $request, Empresa $empresa, Setor $setor)
    {
        $data = $request->validate([
            'nome' => ['required', 'string', 'max:255'],
        ]);
        $setor->update($data);
        return redirect()->route('empresas.setores.index', $empresa)->with('success', 'Setor atualizado com sucesso.');
    }

    public function destroy(Empresa $empresa, Setor $setor)
    {
        $setor->delete();
        return redirect()->route('empresas.setores.index', $empresa)->with('success', 'Setor removido com sucesso.');
    }
}
