<?php

namespace App\Http\Controllers;

use App\Models\ProtocoloResposta;
use App\Models\EmpresaProtocolo;
use Illuminate\Http\Request;

class RelatorioController extends Controller
{
    public function index(Request $request)
    {
        $empresa = auth('empresa')->user();
        if (!$empresa) {
            abort(403);
        }

        $protocolos = $empresa->protocolos()->wherePivot('ativo', true)->get();
        $protocoloId = $request->query('protocolo_id');
        if ($protocoloId === null) {
            $protocoloId = $protocolos->first()?->id;
        } elseif ($protocoloId === '') {
            $protocoloId = null;
        }

        $periodos = collect();
        $periodoId = null;
        if ($protocoloId) {
            $pivot = EmpresaProtocolo::where('empresa_id', $empresa->id)
                ->where('protocolo_id', $protocoloId)
                ->first();
            if ($pivot) {
                $periodos = $pivot->periodos()->orderByDesc('inicio')->get();
                $periodoId = $request->query('periodo_id');
                if ($periodoId === null) {
                    $periodoId = $periodos->first()?->id;
                } elseif ($periodoId === '') {
                    $periodoId = null;
                }
            }
        }

        $analitico = [];
        if ($protocoloId && $periodoId) {
            $protocolo = $protocolos->firstWhere('id', $protocoloId)?->load('perguntas.opcoes');
            $respostas = ProtocoloResposta::where('empresa_id', $empresa->id)
                ->where('protocolo_id', $protocoloId)
                ->where('compartilhar', true)
                ->where('empresa_protocolo_periodo_id', $periodoId)
                ->get();

            if ($protocolo) {
                foreach ($protocolo->perguntas as $pergunta) {
                    $opcoes = [];
                    foreach ($pergunta->opcoes as $opcao) {
                        $count = $respostas->filter(function ($resp) use ($pergunta, $opcao) {
                            return ($resp->respostas[$pergunta->id] ?? null) == $opcao->pontuacao;
                        })->count();
                        $opcoes[] = [
                            'texto' => $opcao->texto,
                            'quantidade' => $count,
                        ];
                    }
                    $analitico[] = [
                        'texto' => $pergunta->texto,
                        'opcoes' => $opcoes,
                    ];
                }
            }
        }

        return view('relatorios.index', compact(
            'protocolos',
            'protocoloId',
            'periodos',
            'periodoId',
            'analitico'
        ));
    }
}
