<?php

namespace App\Http\Controllers;

use App\Models\Pergunta;
use App\Models\PerguntaOpcao;
use App\Models\Protocolo;

class PerguntaOpcaoController extends Controller
{
    public function destroy(Protocolo $protocolo, Pergunta $pergunta, PerguntaOpcao $opcao)
    {
        if ($pergunta->protocolo_id !== $protocolo->id || $opcao->pergunta_id !== $pergunta->id) {
            abort(404);
        }

        $opcao->delete();

        return redirect()->route('protocolos.perguntas', $protocolo)->with('success', 'Opção removida com sucesso.');
    }
}
