<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class EmpresaAuthController extends Controller
{
    /**
     * Display the company login form.
     */
    public function showLoginForm()
    {
        return view('auth.login-empresa');
    }

    /**
     * Handle an authentication attempt for a company.
     */
    public function login(Request $request)
    {
        $credentials = $request->validate([
            'email' => ['required', 'email'],
            'password' => ['required'],
        ]);

        $remember = $request->boolean('remember-me');

        if (Auth::guard('empresa')->attempt($credentials, $remember)) {
            $request->session()->regenerate();
            return redirect()->route('dashboard.resultados');
        }

        return back()->withErrors([
            'email' => 'Credenciais inválidas.',
        ])->onlyInput('email');
    }

    /**
     * Log the company out of the application.
     */
    public function logout(Request $request)
    {
        Auth::guard('empresa')->logout();

        $request->session()->invalidate();
        $request->session()->regenerateToken();

        return redirect()->route('empresa.login');
    }
}
